/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package proc.tagging;

import data.structures.tagging.LemmaVector;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.PrintWriter;


public class TreeTagger {
    public final static int FR = 0;
    public final static int EN = 1;

    private String treeTaggerDir = data.base.Config.getTreeTaggerDirectory();
    private String program = new String(treeTaggerDir + "bin\\tag-french.bat");
    private String tpsFile = new String(treeTaggerDir + "tps");
    private String tpsExecDir = new String(treeTaggerDir + "bin\\");
    
    // Génération d'un fichier temporaire différent à chaque fois
    private static int nbInstances = 0;

    public TreeTagger() {
        this(FR);
    }

    public TreeTagger(int lng) {
        switch(lng){
            case 0 :
                program = new String(treeTaggerDir + "bin\\tag-french.bat");
                break;
            case 1 :
                program = new String(treeTaggerDir + "bin\\tag-english.bat");
                break;
            default :
        }
        tpsFile = treeTaggerDir + "tps"+nbInstances;
        try{
            new File(tpsFile).createNewFile();
        } catch(Exception e){
            e.printStackTrace();
        }
        nbInstances++;
    }

// crate a TreeTagger object with a new treetagger directorie and a new temp file
    public TreeTagger(String tt, String f) {
        treeTaggerDir = tt;
        program = new String(treeTaggerDir + "bin\\tag-french.bat");
        tpsExecDir = new String(treeTaggerDir + "bin\\");
        tpsFile = f;
    }

// create a vector of lemmaInfos from a text by using TreeTagger
    public LemmaVector processText(String text) {
        text = proc.text.Codecs.nettoieAvantLemmatisation(text);

        String s = null;
        LemmaVector lemmas = new LemmaVector();
        String commandTT[] = {program, tpsFile};
        File workingDirectory = new File(tpsExecDir);

        try {
            PrintWriter fileWriter = new PrintWriter(new BufferedWriter(new FileWriter(tpsFile)));
            fileWriter.println(text);
            fileWriter.close();

            Process p = Runtime.getRuntime().exec(commandTT, null, workingDirectory);

            StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), "ERROR");

            // any output?
            StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(), "OUTPUT");

            // kick them off
            errorGobbler.start();
            //outputGobbler.start();

            lemmas = outputGobbler.tolemmas();

            // any error???
            int exitVal = p.waitFor();
            if (exitVal != 0) {
                //System.out.println("ExitValue: " + exitVal);
            }
        } catch (IOException e) {
            //System.out.println(e);
        } catch (Exception e) {
            //System.out.println(e);
        }
        return lemmas;
    }
}

// class used to handle STDIN and STDOUT
class StreamGobbler extends Thread {

    InputStream is;
    String type;

    StreamGobbler(InputStream is, String type) {
        this.is = is;
        this.type = type;
    }

    @Override
    public void run() {
        try {
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                //System.out.println(type + " TT >" + line);
            }
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public LemmaVector tolemmas() {
        LemmaVector lemmas = new LemmaVector();
        try {
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                lemmas.addLemma(line);
            }
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return lemmas;
    }
}